<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

// =======================
// KONEKSI DATABASE
// =======================
include "../config/koneksi.php";

// =======================
// AMBIL DATA POST
// =======================
$judul        = $_POST['judul'] ?? '';
$isi_pesan    = $_POST['isi_pesan'] ?? '';
$ditulis_oleh = $_POST['ditulis_oleh'] ?? '';

// =======================
// VALIDASI
// =======================
if ($judul == '' || $isi_pesan == '' || $ditulis_oleh == '') {
    echo json_encode([
        "status" => false,
        "message" => "Data tidak lengkap"
    ]);
    exit;
}

// =======================
// SIMPAN KE DATABASE
// =======================
$stmt = $conn->prepare("
    INSERT INTO pesan (
        judul,
        isi_pesan,
        ditulis_oleh,
        waktu_pesan
    ) VALUES (?, ?, ?, NOW())
");

$stmt->bind_param(
    "sss",
    $judul,
    $isi_pesan,
    $ditulis_oleh
);

if ($stmt->execute()) {
    echo json_encode([
        "status" => true,
        "message" => "Pesan berhasil dikirim"
    ]);
} else {
    echo json_encode([
        "status" => false,
        "message" => "Gagal menyimpan pesan"
    ]);
}

$stmt->close();
$conn->close();
