<?php
include "../config/koneksi.php";

/* =========================
   PAGINATION
========================= */
$limit = 10;
$page  = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page  = $page < 1 ? 1 : $page;
$start = ($page - 1) * $limit;

/* total data */
$totalData = $conn->query("SELECT COUNT(*) AS total FROM user")->fetch_assoc()['total'];
$totalPage = ceil($totalData / $limit);

/* helper potong teks */
function shortText($text, $limit = 10) {
    if (!$text) return '-';
    return strlen($text) > $limit
        ? substr($text, 0, $limit) . '...'
        : $text;
}

/* data utama */
$data = $conn->query("
    SELECT 
        u.id,
        u.nama,
        u.foto,
        j.nama_jabatan,
        f.nama_fraksi,
        k.nama_komisi,
        GROUP_CONCAT(a.nama_akd SEPARATOR ', ') AS akd_list
    FROM user u
    LEFT JOIN jabatan j ON u.jabatan_id=j.id
    LEFT JOIN fraksi f ON u.fraksi_id=f.id
    LEFT JOIN komisi k ON u.komisi_id=k.id
    LEFT JOIN user_akd ua ON u.id=ua.user_id
    LEFT JOIN akd a ON ua.akd_id=a.id
    GROUP BY u.id
    ORDER BY u.id DESC
    LIMIT $start, $limit
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="icon" href="../assets/img/dprdlogo.png">
<title>Data Anggota DPRD</title>

<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet">
<link href="../assets/css/argon-dashboard.css?v=2.1.0" rel="stylesheet">

<style>
html, body { height: 100%; }
body { display: flex; }
.g-sidenav-show { display: flex; flex-direction: column; width: 100%; }
.main-content { flex: 1; display: flex; flex-direction: column; }
.footer { margin-top: auto; background: #fff; }
.search-box { width: 220px; }

.text-ellipsis {
  max-width: 140px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}
</style>
</head>

<body class="g-sidenav-show bg-gray-100">
<div class="min-height-300 bg-dark position-absolute w-100"></div>

<!-- SIDEBAR -->
<aside class="sidenav bg-white navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 fixed-start ms-4">
  <div class="sidenav-header">
    <a class="navbar-brand m-0">
      <img src="../assets/img/dprdlogo.png" width="26">
      <span class="ms-1 font-weight-bold">Admin DPRD</span>
    </a>
  </div>
  <hr class="horizontal dark mt-0">
  <div class="collapse navbar-collapse w-auto">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" href="../pages/dashboard.html">Dashboard</a>
      </li>
      <li class="nav-item">
        <a class="nav-link active" href="kelola_anggota.php">Kelola Anggota</a>
      </li>
    </ul>
  </div>
</aside>

<!-- MAIN -->
<main class="main-content position-relative border-radius-lg">

<nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none">
  <div class="container-fluid py-1 px-3">
    <h6 class="text-white mb-0">Data Anggota DPRD</h6>
  </div>
</nav>

<div class="container-fluid py-4">

<div class="card">
  <div class="card-header d-flex justify-content-between align-items-center pb-2">
    <h6 class="mb-0">Daftar Anggota</h6>
    <input type="text" id="searchInput"
           class="form-control form-control-sm search-box"
           placeholder="Cari data...">
  </div>

  <div class="table-responsive p-3">
    <table class="table align-items-center mb-0" id="anggotaTable">
      <thead>
        <tr>
          <th>Foto</th>
          <th>Nama</th>
          <th>Jabatan</th>
          <th>Fraksi</th>
          <th>Komisi</th>
          <th>AKD</th>
          <th class="text-center">Aksi</th>
        </tr>
      </thead>
      <tbody>
      <?php while($row=$data->fetch_assoc()): ?>
        <tr>
          <td>
            <img src="../uploads/user/<?= $row['foto'] ?>"
                 class="rounded-circle"
                 width="40" height="40">
          </td>

          <td class="text-ellipsis" title="<?= htmlspecialchars($row['nama']) ?>">
            <?= shortText(htmlspecialchars($row['nama'])) ?>
          </td>

          <td class="text-ellipsis"><?= shortText($row['nama_jabatan']) ?></td>
          <td class="text-ellipsis"><?= shortText($row['nama_fraksi']) ?></td>
          <td class="text-ellipsis"><?= shortText($row['nama_komisi']) ?></td>
          <td class="text-ellipsis"><?= shortText($row['akd_list']) ?></td>

          <td class="text-center">
            <a href="edit_anggota.php?id=<?= $row['id'] ?>"
               class="btn btn-sm btn-warning">Ubah</a>
          </td>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>

  <!-- PAGINATION -->
  <div class="card-footer d-flex justify-content-center">
    <ul class="pagination pagination-sm mb-0">
      <?php for($i=1; $i<=$totalPage; $i++): ?>
        <li class="page-item <?= $i==$page?'active':'' ?>">
          <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
        </li>
      <?php endfor; ?>
    </ul>
  </div>
</div>

</div>

<footer class="footer pt-3 text-center text-muted">
© 2025 Admin DPRD
</footer>

</main>

<script src="../assets/js/core/bootstrap.min.js"></script>
<script src="../assets/js/argon-dashboard.min.js?v=2.1.0"></script>

<script>
document.getElementById("searchInput").addEventListener("keyup", function () {
  const filter = this.value.toLowerCase();
  document.querySelectorAll("#anggotaTable tbody tr").forEach(row => {
    row.style.display = row.innerText.toLowerCase().includes(filter) ? "" : "none";
  });
});
</script>

</body>
</html>
